#version 330
#extension GL_EXT_gpu_shader4 : enable
//Chocolate and VanillaMod01.fsh  by   Yusef28
//https://www.shadertoy.com/view/WtjSzw
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float random (in vec2 st) {
    return fract(sin(dot(st.xy,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

// Based on Morgan McGuire @morgan3d
// https://www.shadertoy.com/view/4dS3Wd
float noise (in vec2 st) {
    vec2 i = floor(st);
    vec2 f = fract(st);

    // Four corners in 2D of a tile
    float a = random(i);
    float b = random(i + vec2(1.0, 0.0));
    float c = random(i + vec2(0.0, 1.0));
    float d = random(i + vec2(1.0, 1.0));

    vec2 u = f * f * (3.0 - 2.0 * f);

    return mix(a, b, u.x) +
            (c - a)* u.y * (1.0 - u.x) +
            (d - b) * u.x * u.y;
}

#define OCTAVES 4 //2 and 3 are ok 
float rauchen (in vec2 st) {
    // Initial values
    float value = 0.0;
    float amplitude = .5;
    float frequency = 0.;
    //
    // Loop of octaves
    for (int i = 0; i < OCTAVES; i++) {
        value += amplitude * noise(st+iTime/8.);
        st *= 2.;
        amplitude *= .5;
    }
    return clamp(value, 0., 1.);
}


float shattenKreise(vec2 p, float r, float i)
    {
       p +=vec2(0.02);//light direction
        
        float a  =atan( p.y,p.x);
        float shape = rauchen(p);
 	float ss = 0.003;
        float s = -0.001;
    float k = 1.0-smoothstep(r-ss+s, r+ss+s, shape)/1.2;
    return pow(k,0.6);
}

float rimKreise(vec2 p, float r, float i)
{
    float a  =atan( p.y,p.x);
    float shape = rauchen(p);
 	float ss = 0.002;
    
    float rim = 0.0008;
    float k = smoothstep(r-ss, r+ss, shape);
    float k2 = smoothstep(r-ss+rim, r+ss+rim, shape);
    k =k-k2;
    return clamp(k*1., 0.0, 1.);
}

float Kreise(vec2 p, float r, float i)
{
 	float ss = 0.001;
    float a  =atan( p.y,p.x);
    float shape = rauchen(p);
    
    float k = smoothstep(r-ss, r+ss, shape);   
    return k;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
	uv = uv*2.0-1.0;
    uv.x*=iResolution.x/iResolution.y;

    float c = 0.;
    vec3 col = vec3(c, c*c*c*c, c*c*c);
    float t = vec3(texture2D(iChannel0,uv/2.)).x;
    float t1 = vec3(texture2D(iChannel1,uv/2.)).x;

    col=col*1.5*t/1.+0.05;

    for(float i = 1.;i<15.;i++){
    	t = vec3(texture2D(iChannel0,uv/3.+vec2(i/3., 0.))).x/1.2;
    	col *=shattenKreise(uv, 0.2+i/20., i); 
    	float g = i/10.;
        
    	col = mix(col, vec3(g, g*g, g*g*g)*1.9*t/1.+0.0, Kreise(uv, 0.2+i/20., i));
		col = mix(col, vec3(g, g*g, g*g*g)*1.3, rimKreise(uv, 0.2+i/20., i/20.));
    }
    
    // Output to screen
    gl_FragColor = vec4(col*1.8,1.0);
}